#pragma rtGlobals=1		// Use modern global access method.
#include "DWS_Utilities SAS"
#Include "DWS_Plot Fits"

Menu "DMA"
	
	 "Load TA_DMA", LoadTA_DMA()
	 "Load BFR DMA", LoadBFRDMA()
	 "Load MT DMA", LoadMT_DMA()
	 "-"
	 "Plot Modulii",PlotDMA()
	 "-"
	 "Generic DMA Plots", GenericDMAPlot()
	 "Generic Add to Plot", DMAAddToPlot()
	 "-"
	"Stadardize Plot Size", StdDMAGraph()
	"Fix Names", Fixnames()
end

Function LoadMT_DMA()
	SetDataFolder root:
	string filename,fullpath,Line,samplename,headertext,lastline
	string/g Root:Packages:P:gfilename
	variable counter=0,refno,endchar
	Open/R/T=".txt"/m="File Containing Information for Wave Note" refno
	fullpath=s_filename
 	filename=getfilename(s_filename)
	samplename=filename
	HeaderText=filename+"\r"
		do//get the header information
			FReadLine refno, Line
			if (stringmatch(line,"")==1)//last line
				print lastline//line before the first blank line where sample name is located
				close refno
				break
			elseif(Counter<2)// picks off the header
				Headertext+=Line	
			endif
				lastline=line
				Counter+=1
		while(1)
		//get name from last line of file
		samplename=lastline
		endchar= strsearch(samplename, ",", 0  )-1
		samplename=samplename[0,endchar]//drop end text
		samplename=Getnamechanges(samplename)//ask to change name of folder
		//samplename=cleanupName(samplename,0)	//remove illegal characters
	
	if (DataFolderExists(samplename)!=1)
		Newdatafolder/S $samplename
	else
		Setdatafolder $samplename
	endif
	string/g Header="",filelocation=""//null string in case it already exists
	Header=headerText//converts to global string
	LoadWave /q/A=wave/D/G/K=1/V={"\t, "," $",0,0}/L={0,2,0,0,0} s_filename
	duplicate/o wave0,Index
	duplicate/o wave1,Ts_C
	duplicate/o wave2,t_s
	duplicate/o wave3,f_Hz
	duplicate/o wave4,F_N
	duplicate/o wave5,x_um
	duplicate/o wave6,Phase
	duplicate/o wave7,F0_N
	duplicate/o wave8,x_um
	duplicate/o wave9,Tr_C
	duplicate/o wave10,E_pri_Mpa
	duplicate/o wave11,E_dblpri_Mpa
	duplicate/o wave12,E_star_Mpa
	duplicate/o wave13,tan_delta
	duplicate/o wave14,D_pri
	duplicate/o wave15,D_dblpri
	duplicate/o wave16,D_star
	killwaves/z wave0,wave1,wave2,wave3, wave4, wave5, wave6,wave7 wave8,wave9, wave10, wave11, wave12, wave13,wave14,wave15,wave16
	filelocation= fullpath
end




Macro LoadBFRDMA()
	setdatafolder root:
	If (datafolderexists("P")==0)
		NewDataFolder/O P//dont change this parameter Folder
	endif
	string filename//,s_filename
	variable refno=2
	Open /R/m="open TA DMA file"  refno as filename
	
		string loadname=s_filename
	String Name=getfilename(S_Filename)
	Name=cleanupname(Name,0)
	Name=Name[0,29]
	string foldername="D"+Name
	foldername=Entername(foldername)
	print strlen(foldername)
	if (DataFolderExists(foldername)!=1)
		newdatafolder $foldername
	endif
	setdatafolder $foldername
	LoadWave/J/W/O/K=0/L={0,2,0,0,0} loadname
	fixnames()
endmacro



Macro LoadTA_DMA(npts)//must be plain text, not unicode text
	variable npts=21
	Prompt npts,"Number of points per pass (0 for 1 pass)"//for multiple runs
	silent 1
	setdatafolder root:
	If (datafolderexists("P")==0)
		NewDataFolder/O P//dont change this parameter Folder
	endif
	setdatafolder root:P
	variable startname,refno=2,counter,Nsig;string headerpart="", Head="",signalnames
	string filename
	Open /R/m="open TA DMA file"  refno as filename
	do
		FReadLine  refNo, headerpart
		Head+=headerpart
		counter+=1
		//Print num2str(counter)+"  "+headerpart
		if ((stringmatch(headerpart, "sig*" ))==1)//look for signal names
			startname=strsearch(headerpart,"\t",1)
			signalnames+= (headerpart[startname+1,(32+startname)])
		endif
		if ((stringmatch(headerpart, "Nsig*" ))==1)//look for Number of signals
			startname=strsearch(headerpart,"\t",1)
			Nsig= str2num(headerpart[(startname+1),(startname+3)])
		endif
	while (((stringmatch(headerpart, "*OrgFile*" ))==0))
	Close refno
	signalnames="\r"+signalnames
	variable counter1=0,maxlen=strlen(signalnames)
	silent 1
	do
		if(cmpstr(signalnames[counter1],"(")==0)
				signalnames[counter1,counter1]="_"				
		endif
		if(cmpstr(signalnames[counter1],"")==0)
			signalnames[counter1,counter1]=""		
		endif
		if(cmpstr(signalnames[counter1],"")==0)
			signalnames[counter1,counter1]=""			
		endif
		if(cmpstr(signalnames[counter1],"%")==0)
			signalnames[counter1,counter1]="pct"		
		endif
		if(cmpstr(signalnames[counter1],")")==0)
			signalnames[counter1,counter1]=""	
		endif				
		if(cmpstr(signalnames[counter1]," ")==0)
			signalnames[counter1,counter1]=""	
		endif	
		counter1+=1
	while(counter1<maxlen)
	string loadname=s_filename
	String Name=getfilename(S_Filename)
	Name=cleanupname(Name,0)
	Name=Name[0,strlen(Name)-5]
	string foldername="D"+Name
	signalnames=signalnames[0,(strlen(signalnames)-1)]//remove last return
	//LoadWave/J/M/N=wave/O/K=0/L={0,(counter),0,0,0} loadname
	LoadWave/G/M/A=wave   loadname
	counter=0
	string newwave

	Make/O/n=(DimSize(wave0, 0)) temp
	temp[]=root:P:wave0[p][3]
	variable passes=1, colcounter,start,totalpnts=numpnts(root:P:temp)
	string parsedwave
	setdatafolder root:
	colcounter=0
	foldername=Getnamechanges(foldername)//user change name

	if (DataFolderExists(foldername)!=1)
			newdatafolder $foldername
	endif
	setdatafolder $foldername
	string/g Header=head
	variable size,newthick,oldthick
	size=strsearch(header,"Size",0)
			
	do
		newwave=cleanupname( StringFromList(colcounter+1, signalnames, "\r"),0)
		make/o/n=(totalpnts) $newwave
		$newwave[]=root:P:wave0[p][colcounter]
		colcounter=colcounter+1
		start=0;passes=1
		IF (npts!=0)
				do //parse the wave, npts is usually 28
					parsedwave=newwave+"_"+num2str(passes)
					make/o/n=(npts) $parsedwave
					$parsedwave=$newwave[start+p]
					start=start+npts
					passes=passes+1
				while (start<totalpnts)
		endif
	while (colcounter<Nsig)//following changes thickness
			//Doalert 1, name+"\r"+header[size+21, size+30]+"\rChange Thickness?"
			//If (V_flag==1)
			//	oldthick=str2num(header[size+21, size+30])
			//	print oldthick
			//	newthick=Changethickness(oldthick,oldthick)		
			//	Header="\rThickness changed to "+num2str(newthick)+" and storage and loss corrected\r"+header
			//endif
	plotDMA1()
	killwaves/z root:P:wave0,root:P:temp
	LoadTA_DMA()
endmacro

function Changethickness(oldthick,newthick)
	Variable oldthick,newthick
	//Prompt oldthick, "Enter Old Thickness"
	prompt newthick, "Enter New Thickness"
	doprompt "Thickness Panel", newthick
	Doalert 1, "Old = "+num2str(oldthick)+"\rNew = "+num2str(newthick)+"\rChange?"
	If (V_flag==1)
		wave storage=StorageModulus_MPa
		wave Loss=LossModulus_MPa
		storage*=(oldthick/newthick)
		Loss*=(oldthick/newthick)
	endif
	return newthick
end



Macro plotDMA()
	SetOperationFolder()
	 plotDMA1()
endmacro

macro plotDMA1()
string foldername=GetDataFolder(0 )
	Display/k=1 StorageModulus_MPa,LossModulus_MPa,TanDelta vs Strain_pct as foldername
	ChangetoLineandPoints(4,1)
	Legend/C/N=text2/J/A=MT foldername+"\r\\s(StorageModulus_MPa) StorageModulus_MPa\r\\s(LossModulus_MPa) LossModulus_MPa";DelayUpdate
	AppendText "\\s(TanDelta) TanDelta"
	Label bottom "Strain (%)"
	ModifyGraph log=1
endmacro

Macro StdDMAGraph(MAXY)
	variable/g root:Packages:P:gmaxy
	variable maxy=root:Packages:P:gmaxy
	prompt maxy,"Enter max Y"
	
	root:P:gmaxy=maxy
	ModifyGraph log(left)=0;delayUpdate
	ModifyGraph width=300,height={Aspect,1}
	ModifyGraph axThick=2;DelayUpdate
	Label left "StorageModulus (MPa)";DelayUpdate
	Label bottom "";DelayUpdate
	SetAxis left 0,maxy ;DelayUpdate
	SetAxis bottom 0.01,50 ;DelayUpdate
	ModifyGraph mirror(bottom)=1;DelayUpdate
	ModifyGraph grid=0;DelayUpdate
	ModifyGraph width=0,height=0;DelayUpdate
	if(stringmatch( AxisList(""), "*right*") )
			SetAxis right 0,1
		else
			ModifyGraph mirror=1
	endif
endmacro

Macro GenericDMAPlot()
	SetOperationFolder()
	GenericDMAPLOT1()
	 GenericAddLegend()
	string DF=  StringByKey("CWAVEDF", AxisInfo("","left"))
	string fullpath=DF+StringByKey("CWAVE", AxisInfo("","left"))
	print fullpath
	setAxis/A/E=1 left//doesn't do anything on log axis
	if(stringmatch(AxisList(""), "*right*" ))
		SetAxis right 0,1//remove this later
	endif
	StdDMAgraph()
endmacro

macro GenericDMAPLOT1(Ya,Yr,Xa,qlogx,qlogy,numberofwaves)
	VARIABLE/G root:Packages:P:logx,root:Packages:P:logy
	string/g root:Packages:P:xvalue,root:Packages:P:yvalue,root:Packages:P:yrvalue
	variable numberofwaves=1,qlogx=root:Packages:P:logx,qlogy=root:Packages:P:logy
	String Xa=root:Packages:P:xvalue,Ya=root:Packages:P:yvalue,Yr=root:Packages:P:yrvalue
	Prompt Ya,"Enter the Left Ycolumn:",popup,WaveList("*", ";", "")
	Prompt Yr,"Enter the right Ycolumn:",popup,"none;"+WaveList("*", ";", "")
	Prompt Xa,"Enter the Xcolumn:",popup,WaveList("*", ";", "")
	Prompt qlogx,"Log x axis?",popup,"Yes;No"
	Prompt qlogy,"Log y axis?",popup,"Yes;No"
	Prompt numberofwaves,"How Many Waves? (1)"
	print yr
	root:Packages:P:logx=qlogx
	root:Packages:P:logy=qlogy
	string foldername=GetDataFolder(0 )
	 root:Packages:P:xvalue=Xa;root:Packages:P:yvalue=Ya;root:Packages:P:yrvalue=Yr
	Silent 1;pauseupdate
	variable/g root:Packages:P:sym=3
	Display $Ya vs $Xa
	if (!stringmatch(yr, "none"))
		AppendToGraph/R $Yr vs  $Xa
	endif
	if (qlogx==1)
		Modify log(bottom)=1
	endif
	if(qlogy==1)
		Modify log(left)=1
	endif
	Modify grid=2,tick=2,minor=1,font="Geneva",zero(left)=1,standoff=0;DelayUpdate
	Label bottom Xa;DelayUpdate
	Label left Ya
	if (!stringmatch(yr, "none"))
		Label right Yr
	endif
	ShowInfo;ShowTools
	Modify tick=2,fStyle=1,fSize=15,standoff=0;DelayUpdate
	Modify font="Geneva"
	

	variable count=1
	if(numberofwaves>1)
		do	
			DMAAddToPlot()
			count+=1
		while(count<numberofwaves)
	endif
	ChangetoLineandPoints(4,1)
endmacro
	
Macro DMAAddToPlot()
	Setoperationfolder()
	DMAAddToPlot1()
	ChangetoLineandPoints(4,1)
	GenericAddLegend()
endmacro

function GenericAddLegend()//adds folder legend
	Silent 1;pauseupdate	
	//How Many Waves:
	variable NumberofWaves=ItemsInList(tracenamelist("",";",1))
	variable counter=1
	string theFolder,TheText
	string list=TraceNameList("",";",1)
	string tracename= StringFromList(0, list,";")//getstrfromlist (list, 0,";")
	theFolder=GetWavesDataFolder(WaveRefIndexed("",0 ,1),0)
	NVAR GraphLegendSize=root:Packages:Packages:GeneralplottingTool:GraphlegendSize
	theText="\Z"+num2str(graphlegendSize)
	theText=theText+ "\s("+tracename+")"+theFolder[0,(strlen(theFolder)-0)]
	
	if(NumberofWaves>1)
		do
			tracename= StringFromList(counter, list,";")//getstrfromlist (list,(counter),";")
			//first get the dat folder to the waves of index counter
			theFolder=GetWavesDataFolder(WaveRefIndexed("",counter ,1),0)
			theText+="\r\s("+tracename+") "+theFolder[0,(strlen(theFolder)-0)]
			
			counter+=1
		while(counter<Numberofwaves)
	endif
	TextBox/C/N=FolderLegend theText
End

Macro DMAAddToPlot1()
	VARIABLE/G root:Packages:P:sym
	STRING/G root:Packages:P:xvalue,root:Packages:P:yvalue,root:Packages:P:yrvalue
	String Xa=root:Packages:P:xvalue,Ya=root:Packages:P:yvalue,Yr=root:Packages:P:yrvalue
	Silent 1;PAUSEUPDATE	
	Append $Ya vs $Xa
	if (!stringmatch(yr, "none"))
		AppendToGraph/R $Yr vs  $Xa
	endif
	//Legend/C/N=added/J/A=MC "\\s('"+Ya+"')"+ya
	root:Packages:P:sym=root:Packages:P:sym+1
	ModifyGraph lsize($Ya)=2
	ModifyGraph rgb($Ya)=(0,0,0)
EndMacro

macro Fixnames()
	//Setoperationfolder()
	string Name,Names,text,newwave
	Names=WaveList("*", ";", "")
	variable/g Multiplier
	variable counter=0
	do
		Name=StringFromList(counter, Names,";")
		if (stringmatch(Name, "" ))
			break
		endif
		text="Pick a name for "+Name
		newwave=selectname(Name,"", text,Name,1)
		If(!stringmatch(newwave, Name ))
			Duplicate/O  $name, $newwave; KillWaves $name
		endif
		$newwave=multiplier*$newwave
		print multiplier
		counter=counter+1
	while (1)
	killvariables multiplier
	
Endmacro

function/s SelectName(name,choice,text,Userchoice,multiplier)
	string name,text,choice,userchoice
	variable multiplier
	string choices="Other;Time_min;Temperature_C;StorageModulus_MPa;LossModulus_MPa;TanDelta;Frequency_Hz;Amplitude_m;Stress_MPa;Strain_pct;Displacement_m;StaticForce_N"
	Prompt Choice, text, popup, choices
	prompt Userchoice, "othername"
	prompt multiplier,"multipier (10-7 x dyne/cm2=MPa, 10-5 x gm-cm=N-m):"
	DoPrompt "Enter New Name",choice,userchoice,multiplier
	
	if(stringmatch(choice, "Other" ))
		choice=userchoice
	endif
	nvar mult=multiplier
	mult=multiplier
	return choice
end